﻿var panels = {
    context: $(".v-panels"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".v-panelsTable", this.context).a4datatable({
            height: "full",
            stateKey: "SettingsPanels",
            ajaxAction: a4.getAction("GetPanels", "Home", "Panel"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Searchable": false },
                { "Name": "Name", "Title": resources.PanelName, "HideInSelector": true },
                { "Name": "Description", "Title": resources.Description, "Visible": false },
                { "Name": "Size", "Title": resources.Size },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn }
            ],
            toolBarItems: panels.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                if (action == "delete") {
                    panels.deleteItems(_.pluck(rows, "Id"));
                }
            },
            contextMenuItems: panels.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "redirect":
                        window.location = a4.getAction(data.params.action, data.params.controller, "Panel", { id: row.Id });
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("Edit", "Home", "Panel", { id: row.Id }), 600, 700, { afterClose: function () { panelMenu.refresh(); } });
                        break;
                    case "delete":
                        panels.deleteItems(row.Id);
                        break;
                    case "permissions":
                        modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: row.Id, name: row.Name, objectType: "Panel" }), 550, 700);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchPanel }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addPanel", function () {
            modalDialog.showWindow(a4.getAction("Edit", "Home", "Panel"), 500, 700, { afterClose: function () { panels.refreshDataTable(); } });
        });

        panelMenu.onAfterRefresh = function () {
            panels.refreshDataTable();
        };
    },
    refreshDataTable: function () {
        this.datatable.a4datatable("refresh");
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeletePanelsResources, function () {
            a4.callServerMethod(a4.getAction("DeletePanels", "Home", "Panel"), { ids: items },
                function (result) {
                    panels.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    canModifyPanel: $("#CanModifyPanel").val() == "True",
    getToolBarItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    getContextMenuItems: function () {
        var canViewPanelSetup = function (data) { return data.CanViewPanelSetup; };
        var canViewPanelists = function (data) { return data.CanViewPanelists; };
        var canModifyPanelSetup = function (data) { return data.CanModifyPanelSetup; };
        var canViewPanelistExportation = function (data) { return data.CanViewExportPanelist; };
        var isAdmin = function () { return isUserAdmin; };

        var items = [{ "Action": "redirect", "Params": { action: "Overview", controller: "Home" }, "Label": resources.Overview, "DisplayCondition": canViewPanelSetup }];

        items.push({ "Action": "redirect", "Params": { action: "Attributes", controller: "Home" }, "Label": resources.Attributes, "DisplayCondition": canViewPanelSetup });
        items.push({ "Action": "redirect", "Params": { action: "Groups", controller: "Home" }, "Label": resources.Groups, "DisplayCondition": canViewPanelSetup });
        items.push({ "Action": "redirect", "Params": { action: "EmailTemplates", controller: "Home" }, "Label": resources.EmailTemplates, "DisplayCondition": canViewPanelSetup });

        items.push({ "Divider": true });
        items.push({ "Action": "permissions", "Label": resources.EditPermissions, "DisplayCondition": isAdmin });
        items.push({ "Divider": true });

        items.push({ "Action": "redirect", "Params": { action: "Index", controller: "Panelists" }, "Label": resources.Panelists, "DisplayCondition": canViewPanelists });

        items.push({ "Action": "redirect", "Params": { action: "Index", controller: "Samples" }, "Label": resources.Samples, "DisplayCondition": function (data) { return data.CanViewSamples; } });

        items.push({ "Action": "redirect", "Params": { action: "Index", controller: "Import" }, "Label": resources.Import, "DisplayCondition": function (data) { return data.CanViewImport; } });

        items.push({ "Action": "redirect", "Params": { action: "Index", controller: "PanelistExportations" }, "Label": resources.Export, "DisplayCondition": canViewPanelistExportation });

        items.push({ "Divider": true });
        items.push({ "Action": "delete", "Label": resources.Delete, "DisplayCondition": canModifyPanelSetup });
        items.push({ "Action": "properties", "Label": resources.Properties, "DisplayCondition": canModifyPanelSetup });
        return items;
    }
}

$(document).ready(function () {
    if (panels.context.length > 0) {
        panels.initializeDataTable();
        panels.bindEvents();
    }
});